<?php
/* --------------------------------------------------------------
 DefaultCustomerGroup.php  2019-10-25
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2019 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Core\Configuration\Types;

use Gambio\Core\Configuration\Models\Read\Collections\Options;
use Gambio\Core\Configuration\Repositories\Components\OptionsResolver;

/**
 * Class DefaultCustomerGroup
 * @package Gambio\Core\Configuration\Types
 */
class DefaultCustomerGroup implements ConfigurationType
{
    /**
     * Resolves possible options for the current type.
     * This is used to provide selectable list in the ui and can be null.
     *
     * @param OptionsResolver $resolver
     * @param string|null     $value
     *
     * @return Options|null
     */
    public function toOptions(OptionsResolver $resolver, string $value = null): ?Options
    {
        $connection = $resolver->connection();
        $qb         = $connection->createQueryBuilder();
        
        $notIn = $qb->expr()->andX($qb->expr()->notIn('customers_status_id', ['0', '1']));
        
        $customerGroups = $qb->select('`customers_status_id` as `value`, `customers_status_name` as `text`')
            ->from('customers_status')
            ->where('language_id = ' . $qb->createNamedParameter($resolver->languageId()))
            ->andWhere($notIn)
            ->orderBy('customers_status_id')
            ->execute()
            ->fetchAll();
        
        return Options::fromArray($customerGroups);
    }
    
    
    /**
     * Defines the UI's input type for current configuration type.
     *
     * @return string
     */
    public function inputType(): string
    {
        return 'dropdown';
    }
}